﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;
using System.Collections.Generic;
using System.Linq;
using VeteransAffairs.Registries.BusinessAHOBPR;

namespace WCF_BusinessManagerAHOBPRTests.EMIS
{
    [TestClass]
    public class BranchesOfServiceManagerTests
    {
        private BranchesOfServiceManager _cut;

        [TestInitialize()]
        public void MyTestInitialize()
        {
            _cut = new BranchesOfServiceManager();
        }
        [TestMethod()]
        public void AssociateBranchesOfServiceWithDatesServed_Is_Not_Null_When_Given_Empty_List()
        {
            var actual = _cut.AssociateBranchesOfServiceWithDatesServed(new List<MilitaryServiceEpisode>());
            Assert.IsNotNull(actual);
            Assert.AreEqual(0, actual.Keys.Count);
        }
       
        [TestMethod()]
        public void AssociateBranchesOfServiceWithDatesServed_Test()
        {
            DateRange expectedKey = new DateRange(DateTime.Parse("2002-04-07"), DateTime.Parse("2011-01-24"));
            var edipi = "1019061961";
            var inputEdipi = new InputEdipiIcn();
            inputEdipi.edipiORicnValue = edipi;
            inputEdipi.inputType = InputEdipiIcnInputType.EDIPI;
            var input = new inputEdiPiOrIcn();
            input.edipiORicn = inputEdipi;

            var inputHeaderInfo = new InputHeaderInfo();
            List<MilitaryServiceEpisode> list = GetMilitaryServiceEpisodeTestData(edipi);
            Dictionary<DateRange, string> actual = _cut.AssociateBranchesOfServiceWithDatesServed(list);

            Assert.AreEqual(expectedKey.Start, actual.Keys.First().Start, "Failure: Expected Start value: " + expectedKey.Start + " does not equal actual Start value: " + actual.Keys.First().Start);
            Assert.AreEqual(expectedKey.End, actual.Keys.First().End, "Failure: Expected End value: " + expectedKey.End + " does not equal actual End value: " + actual.Keys.First().End);
        }
        public List<MilitaryServiceEpisode> GetMilitaryServiceEpisodeTestData(string edipi)
        {
            var ep = new MilitaryServiceEpisode();
            ep.edipi = edipi;
            ep.keyData = new KeyData
            {
                personnelOrganizationCode = "41",
                personnelCategoryTypeCode = "V",
                personnelSegmentIdentifier = "1"
            };
            ep.militaryServiceEpisodeData = new MilitaryServiceEpisodeData
            {
                serviceEpisodeStartDate = DateTime.Parse("2002-04-07"),
                serviceEpisodeEndDate = DateTime.Parse("2011-01-24"),
                serviceEpisodeTerminationReason = "S",
                branchOfServiceCode = "A",
                dischargeCharacterOfServiceCode = "B",
                personnelStatusChangeTransactionTypeCode = "313",
                narrativeReasonForSeparationCode = "999",
                narrativeReasonForSeparationTxt = "UNKNOWN",
                mgadLossCategoryCode = "11",
                payPlanCode = "ME",
                payGradeCode = "08",
                serviceRankNameCode = "MSG",
                serviceRankNameTxt = "Master Sergeant",
                payGradeDate = DateTime.Parse("2008-12-30")

            };
            return new List<MilitaryServiceEpisode> { ep };

        }

        /// <summary>
        /// Helper method to use Emis to generate test data
        /// </summary>
        /// <param name="branchesOfService"></param>
        //private void WriteBranchesOfService(Dictionary<DateRange, string> branchesOfService)
        //{
        //    if (branchesOfService == null) throw new ArgumentNullException(nameof(branchesOfService));
        //    Console.WriteLine("new Dictionary<DateRange, string>{");
        //    foreach (KeyValuePair<DateRange, string> kvp in branchesOfService)
        //    {
        //        Console.Write($"{{new DateRange(DateTime.Parse(\"{kvp.Key.Start.ToShortDateString()}\")), ");
        //        Console.WriteLine($"DateTime.Parse(\"{ kvp.Key.End.ToShortDateString()}\")), \"{kvp.Value}\"}},");
        //    }
        //    Console.WriteLine("};");

        //}
    }
}
